# 画面設計書 27-Runtime Config Test（StartupHook）

## 概要

本ドキュメントは、WebAssembly スタートアップフックテスト画面（index.html）の画面設計書です。.NET WebAssembly 環境における STARTUP_HOOKS 機能が正しく動作し、アプリケーション起動前にフックコードが実行されることをテストするための HTML/JavaScript ページとして実装されています。

### 本画面の処理概要

この画面は、.NET WebAssembly 環境でスタートアップフック（STARTUP_HOOKS）が正しく実行され、フックコードで設定された AppContext データがアプリケーションコードから参照できることを検証するためのテストページです。

**業務上の目的・背景**：本画面は .NET Runtime の機能テストとして、WebAssembly 環境における STARTUP_HOOKS 機能を検証するために存在します。スタートアップフックは、アプリケーションの Main メソッドが実行される前にカスタムコードを実行できる機能であり、アプリケーションの初期化処理やグローバル設定の適用に使用されます。この機能が WebAssembly 環境でも正しく動作することを確認します。

**画面へのアクセス方法**：WebAssembly アプリケーションをビルド・起動後、ブラウザで index.html にアクセスすることで本画面が表示されます。

**主要な操作・処理内容**：
1. ページ読み込み時に .NET WebAssembly ランタイムを初期化
2. ランタイム初期化時にスタートアップフック（StartupHookForFunctionalTest）が自動実行
3. スタートアップフックで `AppContext.SetData("Test.StartupHookForFunctionalTest.DidRun", "Yes")` を設定
4. JavaScript から .NET の `TestMeaning()` メソッドを呼び出し
5. `AppContext.GetData("Test.StartupHookForFunctionalTest.DidRun")` で値を検証
6. 値が "Yes" であることを確認
7. テスト結果（42: 成功、104: 失敗）を画面とコンソールに出力

**画面遷移**：本画面は単独で動作するテストページであり、他の画面への遷移機能はありません。

**権限による表示制御**：本画面は認証・認可による表示制御を実装していません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Mono | 主機能 | WebAssemblyスタートアップフックのテスト実行 |
| 59 | WebAssembly Workload | 主機能 | WebAssemblyアプリケーションのビルドと実行をサポート |
| 34 | Microsoft.Extensions.Hosting | 補助機能 | スタートアップフックのホスティング統合テスト |

## 画面種別

機能テストページ / スタートアップフックテスト

## URL/ルーティング

- **URL**: `/index.html`（静的 HTML ファイル）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ret | 出力 | int | - | テスト結果コード（42: 成功、104: 失敗） |

## 表示項目

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|--------------|------|
| ページタイトル | title | 固定値 | "Runtime config test" |
| ヘッダー | h3 | 固定値 | "Runtime config test" |
| 結果表示プレフィックス | テキスト | 固定値 | "Answer to the Ultimate Question of Life, the Universe, and Everything is :" |
| テスト結果 | span#out | ret 変数 | テスト結果の数値（正常時: 42） |
| テスト完了フラグ | label#tests_done | exit_code | テスト完了時に動的に追加される要素 |

## イベント仕様

### 1-ページ読み込み時処理

**トリガー**: ページの読み込み完了時（main.js の実行）

**処理フロー**:
1. `dotnet.js` モジュールをインポート
2. `.create()` で .NET ランタイムを初期化
3. 初期化時に STARTUP_HOOKS で指定されたフックが自動実行
4. `getAssemblyExports()` でアセンブリのエクスポートを取得
5. `TestMeaning()` メソッドを呼び出し
6. 結果を `#out` 要素に表示
7. `wasm_exit()` を呼び出してテスト完了を通知

### 2-スタートアップフック実行

**トリガー**: .NET ランタイム初期化時（自動実行）

**処理フロー**:
1. runtimeconfig.json の `STARTUP_HOOKS` 設定に基づきフックアセンブリを読み込み
2. `StartupHookForFunctionalTest` アセンブリの `Initialize` メソッドを実行
3. `AppContext.SetData("Test.StartupHookForFunctionalTest.DidRun", "Yes")` を設定

### 3-TestMeaning メソッド実行

**トリガー**: JavaScript からの呼び出し

**処理フロー**:
1. `AppContext.GetData("Test.StartupHookForFunctionalTest.DidRun")` を呼び出して値を取得
2. 取得した値が "Yes" であるかを検証
3. 成功なら 42 を返却、失敗なら 104 を返却
4. 失敗時はエラーメッセージをコンソールに出力

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースとの連携を行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG-001 | ログ出力 | "ret: {ret}" | TestMeaning 実行後 |
| MSG-002 | ログ出力 | "WASM EXIT {exit_code}" | テスト完了時 |
| MSG-003 | ログ出力 | "WASM ERROR {err}" | エラー発生時 |
| MSG-004 | エラー | "Expected startup hook to set {key} to 'Yes', got '{data}'" | スタートアップフック未実行時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| JavaScript Error | .NET ランタイム初期化失敗 | コンソールに "WASM ERROR" を出力 |
| 検証失敗 | AppContext.GetData() の値が "Yes" でない | 終了コード 104 を返却、エラーメッセージ出力 |

## 備考

- 本画面は `.NET Runtime` リポジトリの機能テストであり、WebAssembly 環境でのスタートアップフック機能を検証する目的で作成されています。
- `runtimeconfig.template.json` で `STARTUP_HOOKS: "StartupHookForFunctionalTest"` を設定しています。
- スタートアップフックはランタイム初期化時に自動的に実行されるため、ユーザー操作なしでテストが進行します。
- テスト結果 42 は「生命、宇宙、そして万物についての究極の疑問の答え」（銀河ヒッチハイク・ガイド）の引用です。
- 失敗時の終了コード 104 は、スタートアップフックが実行されなかったことを示す固有のエラーコードです。
- `tests_done` ラベルはテストランナーがテスト完了を検出するために使用されます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ランタイム設定とスタートアップフックの設定を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runtimeconfig.template.json | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/runtimeconfig.template.json` | STARTUP_HOOKS の設定内容（1-5行目） |

**読解のコツ**: `STARTUP_HOOKS` プロパティで指定されたアセンブリ名のアセンブリが、ランタイム初期化時に自動的に読み込まれ、`Initialize` メソッドが実行されます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/index.html` | HTML 構造と main.js の読み込み（1-18行目） |
| 2-2 | main.js | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/main.js` | .NET ランタイム初期化と TestMeaning 呼び出し（1-24行目） |

**主要処理フロー**:
1. **index.html 11行目**: `<script type='module' src="./main.js">` で main.js を読み込み
2. **main.js 13行目**: `dotnet.create()` でランタイム初期化（この時点でスタートアップフック実行）
3. **main.js 14-17行目**: TestMeaning メソッドの呼び出しと結果表示

#### Step 3: テストロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Program.cs | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/Program.cs` | TestMeaning メソッドの実装（1-30行目） |

**主要処理フロー**:
- **17-18行目**: `[JSExport]` 属性で JavaScript から呼び出し可能に
- **19行目**: `appContextKey` で検証するキーを定義
- **20行目**: `AppContext.GetData()` でスタートアップフックが設定した値を取得
- **22-26行目**: 値が "Yes" でなければエラーメッセージを出力し 104 を返却
- **27行目**: 成功時は 42 を返却

### プログラム呼び出し階層図

```
index.html
    │
    └─ main.js (type="module")
           │
           ├─ import { dotnet } from './_framework/dotnet.js'
           │
           └─ dotnet.create()
                  │
                  ├─ [.NET ランタイム初期化]
                  │      │
                  │      └─ [STARTUP_HOOKS 処理]
                  │             │
                  │             └─ StartupHookForFunctionalTest.Initialize()
                  │                    │
                  │                    └─ AppContext.SetData("Test.StartupHookForFunctionalTest.DidRun", "Yes")
                  │
                  ├─ getAssemblyExports("WebAssembly.Browser.StartupHook.Test.dll")
                  │
                  └─ exports.Sample.Test.TestMeaning()
                         │
                         ├─ AppContext.GetData("Test.StartupHookForFunctionalTest.DidRun")
                         │
                         └─ 値が "Yes" か検証
                                │
                                ├─ [成功] return 42
                                │
                                └─ [失敗] Console.Error.WriteLine() → return 104
```

### データフロー図

```
[入力]                    [処理]                        [出力]

runtimeconfig.json
    │
    └─ STARTUP_HOOKS ───────▶ .NET ランタイム初期化
                                    │
                                    ▼
                             StartupHookForFunctionalTest.Initialize()
                                    │
                                    ▼
                             AppContext.SetData("...DidRun", "Yes")
                                    │
                                    ▼
                             TestMeaning()
                                    │
                                    ▼
                             AppContext.GetData("...DidRun")
                                    │
                                    ▼
                             値が "Yes" か検証 ───────▶ 結果表示
                                                        span#out: 42 or 104
                                                        │
                                                        ▼
                                                   label#tests_done
                                                        │
                                                        ▼
                                                   console: "WASM EXIT"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/index.html` | テンプレート | テストページの HTML |
| main.js | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/main.js` | ソース | JavaScript エントリーポイント |
| Program.cs | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/Program.cs` | ソース | テストロジック（TestMeaning） |
| runtimeconfig.template.json | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/runtimeconfig.template.json` | 設定 | ランタイム設定テンプレート（STARTUP_HOOKS） |
| WebAssembly.Browser.StartupHook.Test.csproj | `src/tests/FunctionalTests/WebAssembly/Browser/StartupHook/WebAssembly.Browser.StartupHook.Test.csproj` | 設定 | プロジェクト設定 |
